class SplashNotify expands SpawnNotify;

var string LogoTexture;
var float LogoDrawDelay;
var float LogoFadeInTime;
var float LogoDrawTime;
var float LogoFadeOutTime;
var string CaptionLineOne;
var string CaptionLineTwo;
var string CaptionLineThree;
var string CaptionLineFour;
var string IntroSound;
var float IntroSoundDelay;
var bool bLogoTranslucent;
var string Position;
var string Size;

var float GameSpeed;

replication
{
	reliable if(Role==ROLE_Authority && bNetInitial)
		LogoTexture,LogoDrawDelay,LogoFadeInTime,LogoDrawTime,LogoFadeOutTime,CaptionLineOne,CaptionLineTwo,CaptionLineThree,CaptionLineFour,IntroSound,IntroSoundDelay,bLogoTranslucent,Position,Size,GameSpeed;
}

simulated function PreBeginPlay()
{
	bAlwaysRelevant = true;
	if(ROLE == ROLE_Authority)
	{
		SetTimer(1.0, true);
	}
}

simulated function PostNetBeginPlay()
{
	local ChallengeHUD PlayerHUD;

	foreach AllActors(Class'ChallengeHUD',PlayerHUD)
	{
		SpawnNotification(PlayerHUD);
	}
}

function Timer()
{
	if(GameSpeed != DeathMatchPlus(Level.Game).GameSpeed)
	{
		GameSpeed = DeathMatchPlus(Level.Game).GameSpeed;
	}
}

simulated event Actor SpawnNotification(actor Actor)
{
	local SplashHUDMutator tmpHUD;

	if (Actor != None)
	{
		if (Actor.IsA('HUD') && (HUD(Actor).HUDMutator == None || !HUD(Actor).HUDMutator.IsA('SplashHUDMutator')))
		{
			tmpHUD = spawn(class'SplashHUDMutator', Actor);
			if (tmpHUD != None)
				{
				tmpHUD.Player = PlayerPawn(Actor.Owner);
				tmpHUD.LogoTexture = LogoTexture;
				tmpHUD.LogoDrawDelay = LogoDrawDelay;
				tmpHUD.LogoFadeInTime = LogoFadeInTime;
				tmpHUD.LogoDrawTime = LogoDrawTime;
				tmpHUD.LogoFadeOutTime = LogoFadeOutTime;
				tmpHUD.CaptionLineOne = CaptionLineOne;
				tmpHUD.CaptionLineTwo = CaptionLineTwo;
				tmpHUD.CaptionLineThree = CaptionLineThree;
				tmpHUD.CaptionLineFour = CaptionLineFour;
				tmpHUD.IntroSound = IntroSound;
				tmpHUD.IntroSoundDelay = IntroSoundDelay;
				tmpHUD.bLogoTranslucent = bLogoTranslucent;
				tmpHUD.Position = Position;
				tmpHUD.Size = Size;
				tmpHUD.GameSpeed = GameSpeed;
				if (HUD(Actor).HUDMutator == None)
					HUD(Actor).HUDMutator = tmpHUD;
				else
				{
					tmpHUD.NextHUDMutator = HUD(Actor).HUDMutator;
					HUD(Actor).HUDMutator = tmpHUD;
				}
			}
		}
	}

	return Actor;
}

defaultproperties
{
	bHidden=True
}
